import { View, FlatList } from "react-native";
import React, { useEffect, useState } from "react";
import { allCategoriesStyle } from "./categoriesStyle";
import { useDispatch } from "react-redux";
import { useSelector } from "react-redux";
import {
    getAllCategory,
    getMoreCategory,
} from "../../redux/slices/categorys/allCategory";
import CategoriesSkeleton from "../../src/skeletons/screens/Categories/CategoriesSkeleton";
import SingleCategory from "./SingleCategory";
import EmptyContent from "../Utilities/EmptyContent/EmptyContent";
import NoWishlistIcon from "../../assets/svgs/empty content/noWishlist.svg";
import CustomActiveIndicator from "../../src/components/CustomLoader/CustomActiveIndicator";
import useLangTranslation from "../../hooks/useLangTranslation";
import MenuNavigation from "../Utilities/CustomHeader/MenuNavigation";

const Categories = (props) => {
    const dispatch = useDispatch();
    const { trans } = useLangTranslation();
    const { allCategory, loading, isRefresh, loadMore, nextPageUrl } =
        useSelector((state) => state.allCategory);
    const [showSubCategory, setShowSubCategory] = useState({
        id: null,
        show: false,
    });

    useEffect(() => {
        let isMounted = true;
        if (isMounted) {
            dispatch(getAllCategory());
        }
        return () => {
            isMounted = false;
        };
    }, []);

    const handleRefresh = () => {
        let isMounted = true;
        if (isMounted) {
            dispatch(getAllCategory());
        }
        return () => {
            isMounted = false;
        };
    };
    const handleLoadMoreCategory = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreCategory({ nextPageUrl }));
        }
        return () => {
            isMounted = false;
        };
    };
    return (
        <View
            style={allCategoriesStyle.wrapper}
        >
            <MenuNavigation
                navigationProps={props.navigation}
                routeName={trans("Categories").toUpperCase()}
            />
            {loading ? (
                <CategoriesSkeleton />
            ) : (
                <View style={allCategoriesStyle.container}>
                    {allCategory?.length > 0 ? (
                        <FlatList
                            data={allCategory}
                            renderItem={({ item }) => (
                                <SingleCategory
                                    item={item}
                                    showSubCategory={showSubCategory}
                                    setShowSubCategory={setShowSubCategory}
                                />
                            )}
                            keyExtractor={(_, i) => "key" + i}
                            refreshing={isRefresh}
                            onRefresh={handleRefresh}
                            showsVerticalScrollIndicator={false}
                            initialNumToRender={10}
                            windowSize={10}
                            onEndReachedThreshold={1}
                            onEndReached={handleLoadMoreCategory}
                        />
                    ) : (
                        <FlatList
                            refreshing={isRefresh}
                            onRefresh={handleRefresh}
                            showsVerticalScrollIndicator={false}
                            ListHeaderComponent={() => (
                                <EmptyContent
                                    Icon={NoWishlistIcon}
                                    text={trans("No Category Found")}
                                />
                            )}
                        />
                    )}
                    {loadMore && <CustomActiveIndicator />}
                </View>
            )}
        </View>
    );
};

export default Categories;
